/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.shorts;

/**
 * List of short numbers.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface ShortList extends ShortCollection {
    int size();
    boolean isEmpty();
    boolean contains(short e);
    ShortIterator iterator();
    short[] toArray();
    short[] toArray(short a[]);
    boolean add(short e);
    boolean remove(short e);
    boolean containsAll(ShortCollection c);
    boolean addAll(ShortCollection c);
    boolean addAll(int index, ShortCollection c);
    boolean removeAll(ShortCollection c);
    boolean retainAll(ShortCollection c);
    void clear();
    boolean equals(Object o);
    int hashCode();

    /**
     * Returns the value at the specified index.
     *
     * @param index the index to retrieve the value from.
     * @return the value at the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    short getAt(int index);

    /**
     * Sets the value at the specified index.
     *
     * @param index the index to set the value at.
     * @param e the new value.
     * @return the value previously present the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    short setAt(int index, short e);

    /**
     * Adds the value at the specified index, and moves elements starting
     * at index to the right.
     *
     * @param index the index to add the value at.
     * @param e the new value.
     * @throws IndexOutOfBoundsException if index < 0 or index > size.
     */
    void addAt(int index, short e);

    /**
     * Removes the value at the specified index, and shifts elements starting
     * at index+1 to the left.
     *
     * @param index the index to remove the value from.
     * @return the value previously present at the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    short removeAt(int index);

    /**
     * Returns the smallest index at which the list contains the specified
     * number.
     * @param e the number to look for
     * @return the smallest index of e
     */
    int indexOf(short e);

    /**
     * Returns the largest index at which the list contains the specified
     * number.
     * @param e the number to look for
     * @return the largest index of e
     */
    int lastIndexOf(short e);

    ShortListIterator listIterator();

    ShortListIterator listIterator(int index);

    ShortList subList(int fromIndex, int toIndex);
}
